
clear all
close all
clc

load("RAMP1")
load("SIN1")
load("STEP_LOAD")

dt1=1/4000;

%% SIN

% time          =  SIN.cinque10.POS.HzUnoCinque.data.time;
% P_1           =  SIN.cinque10.POS.HzUnoCinque.data.P_1;
% P_2           =  SIN.cinque10.POS.HzUnoCinque.data.P_2;
% Spool_FB      =  SIN.cinque10.POS.HzUnoCinque.data.Spool_FB;
% Spool_Cmd     =  SIN.cinque10.POS.HzUnoCinque.data.Spool_Cmd;
% Load_FB_SP    =  SIN.cinque10.POS.HzUnoCinque.data.Load;
% Load_SET      =  SIN.cinque10.POS.HzUnoCinque.data.LoadSet;
% Ki_Force_out  =  SIN.cinque10.POS.HzUnoCinque.data.Ki_Force_out;
% ERR_Force     =  SIN.cinque10.POS.HzUnoCinque.data.ERR_Force;
% G1_out        =  SIN.cinque10.POS.HzUnoCinque.data.G1_out;
% G2_out        =  SIN.cinque10.POS.HzUnoCinque.data.G2_out;
% Gd_out        =  SIN.cinque10.POS.HzUnoCinque.data.Gd_out;
% Gp_Force_out  =  SIN.cinque10.POS.HzUnoCinque.data.Gp_Force_out;
% Gx_out        =  SIN.cinque10.POS.HzUnoCinque.data.Gx_out;
% Kp_Force_out  =  SIN.cinque10.POS.HzUnoCinque.data.Kp_Force_out;
% Offset        =  SIN.cinque10.POS.HzUnoCinque.data.Offset;
% Delta_P       =  P_2-P_1;
% 
% time=1:1:length(Load_SET);
% time=[0 ; time(1:end-1)'*dt1];

%% RAMP

% time          =  RAMP.uno.POS.terzo.data.time;
% P_1           =  RAMP.uno.POS.terzo.data.P_1;
% P_2           =  RAMP.uno.POS.terzo.data.P_2;
% Spool_FB      =  RAMP.uno.POS.terzo.data.Spool_FB;
% Spool_Cmd     =  RAMP.uno.POS.terzo.data.Spool_Cmd;
% Load_FB_SP    =  RAMP.uno.POS.terzo.data.Load;
% Load_SET      =  RAMP.uno.POS.terzo.data.LoadSet;
% Ki_Force_out  =  RAMP.uno.POS.terzo.data.Ki_Force_out;
% ERR_Force     =  RAMP.uno.POS.terzo.data.ERR_Force;
% G1_out        =  RAMP.uno.POS.terzo.data.G1_out;
% G2_out        =  RAMP.uno.POS.terzo.data.G2_out;
% Gd_out        =  RAMP.uno.POS.terzo.data.Gd_out;
% Gp_Force_out  =  RAMP.uno.POS.terzo.data.Gp_Force_out;
% Gx_out        =  RAMP.uno.POS.terzo.data.Gx_out;
% Kp_Force_out  =  RAMP.uno.POS.terzo.data.Kp_Force_out;
% Offset        =  RAMP.uno.POS.terzo.data.Offset;
% Delta_P       =  P_2-P_1;

%% STEP

% time          =  STEP_Load.POS.quinto.data.time;
% P_1           =  STEP_Load.POS.quinto.data.P_1;
% P_2           =  STEP_Load.POS.quinto.data.P_2;
% Spool_FB      =  STEP_Load.POS.quinto.data.Spool_FB;
% Spool_Cmd     =  STEP_Load.POS.quinto.data.Spool_Cmd;
% Load_FB_SP    =  STEP_Load.POS.quinto.data.Load;
% Load_SET      =  STEP_Load.POS.quinto.data.LoadSet;
% Ki_Force_out  =  STEP_Load.POS.quinto.data.Ki_Force_out;
% ERR_Force     =  STEP_Load.POS.quinto.data.ERR_Force;
% G1_out        =  STEP_Load.POS.quinto.data.G1_out;
% G2_out        =  STEP_Load.POS.quinto.data.G2_out;
% Gd_out        =  STEP_Load.POS.quinto.data.Gd_out;
% Gp_Force_out  =  STEP_Load.POS.quinto.data.Gp_Force_out;
% Gx_out        =  STEP_Load.POS.quinto.data.Gx_out;
% Kp_Force_out  =  STEP_Load.POS.quinto.data.Kp_Force_out;
% Offset        =  STEP_Load.POS.quinto.data.Offset;
% Delta_P       =  P_2-P_1;


%% Parametri simulink 

dt=1/4000;
StopTime=time(end);

p_S=280e5;                 %% pressione di alimentazione [Pa]
p_T=1e5;                   %% pressione di scarico [Pa]
P_A0=P_2(1)*10^5;          %% pressione iniziale nelle camere [Pa]  
P_B0=P_1(1)*10^5;          %% pressione iniziale nelle camere [Pa]  
rho=900;                   %% densità olio [kg/m^3]
beta=1560548312.31322;     %% modulo di bulk [Pa]
mu=0.0273;                 %% viscosità dinamica [Pa*s]

%% Parametri Controllo

Ki_Force=0.025;
Ki_offset=Ki_Force_out(1);
i_sat_down_Force=-8;
i_sat_up_Force=8;
Ki_Force=0.025;
G1_bias=-0.4;

Kp_Force=2e-6;

Kp_Force_tau1=0.02;
Kp_Force_tau2=0.02;
Kp_Force_tau3=0.0025;
Kp_Force_tau4=0.0025;

Gp_Force=0.00014;
Gp_Force_tau1=0.01;
Gp_Force_tau2=0.01;

Gd_Force=0;
Gd_Force_tau1=0.01;
Gd_Force_tau1=0.01;

G1_Force=0;
G1_Sat=3;

Gx_Force=0;
Kx_min_Force=1;

G2_Force=0.0001;

Load_FI=3;
Load_pband=300;

Load_pband1=300;


Sat_Force=8;
SV_LC_sign_Force=1;

Dead_Low_Force=0;
Dead_Up_Force=0;

P_FI=2;

%% Servovalvola

sigma_n=150*2*pi;
K_s=0.0000731;
zeta_n=0.7;

w=0.0249;                             %% luce [m]
eps_1=-3.7e-6;                        %% ricoprimento S-A [m]
eps_2=-3.7e-6;                        %% ricoprimento B-T [m]
eps_3=-3.7e-6;                        %% ricoprimento S-B [m]
eps_4=-3.7e-6;                        %% ricoprimento A-T [m]

C_d1=0.39;
C_d2=0.53;
C_d3=0.38;
C_d4=0.50;



bias=0;  % bias [m] calcolato da una prova con comando nullo
% 0.2957

%% Attuatore 

d_stantuffo=0.074;                                        %% diametro stantuffo[m]
d_stelo=0.05;                                             %% diametro stelo [m]
semicorsa1=0.075;                                         %% semicorsa lato camera a pressione P_A [m]
semicorsa2=0.075;                                         %% semicorsa lato camera a pressione P_B [m]
A_1=pi*(d_stantuffo^2-d_stelo^2)/4;                       %% superficie stantuffo camera di spinta [m^2]
A_2=pi*(d_stantuffo^2-d_stelo^2)/4;                       %% superficie stantuffo [m^2]
V_1=A_1*semicorsa1;                                       %% volume iniziale camera uno [m^3]
V_2=A_2*semicorsa2;                                       %% volume iniziale camera due [m^3]
V_ds1=0.018*A_1;                                          %% volume di spazio morto camera uno [m^3]
V_ds2=V_ds1;                                              %% volume di spazio morto camera due [m^3]
x=0;
x_dot=0;



gioco_radiale=1.92e-06;                                   %% gioco radiale [m]
Cd_gioco=0.45;


F_stall=(p_S-p_T)*A_1;

%% foro di by-pass

d_BP=1.3e-3;             %% diametro orifizio [m]
A_BP=pi*d_BP^2/4;        %% sezione di passaggio [m^2]

Cd_BP=0.33;
 

%% Trasduttore

sigma_t=150*2*pi;          %% frequenza propria [rad/s]
zeta_t=0.7;                %% smorzamento [-]
K_t=0.44;                %% guadagno statico [-]

%% Lancio il modello

sim('CL.slx');

%%

close all

figure
title('Carico Sperimentale e Simulato in [N]')
plot(time,Load_SET,'LineWidth',2)
hold on 
plot(tout,Load_FB,'LineWidth',2)
hold on
plot(time,Load_FB_SP,'LineWidth',2)
legend('SET','FB Simulato','FB Sperimentale')
ylabel('Load [N]')
xlabel('t [s]')
set(gca,'FontSize',14)
